package dev.fitko.fitconnect.client.zbp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class ObjectMapperProvider {

    public static ObjectMapper createObjectMapper() {
        return new ObjectMapper()
                .registerModule(new SimpleModule().addSerializer(new CreateDateSerializer()))
                .setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    private static class CreateDateSerializer extends StdSerializer<Instant> {
        private static final DateTimeFormatter formatter =
                new DateTimeFormatterBuilder().appendInstant(3).toFormatter();

        protected CreateDateSerializer() {
            super(Instant.class);
        }

        @Override
        public void serialize(Instant instant, JsonGenerator jsonGenerator, SerializerProvider provider)
                throws IOException {
            String formattedInstant = formatter.format(instant);
            jsonGenerator.writeString(formattedInstant);
        }
    }
}
