package dev.fitko.fitconnect.client.attachments.download;

import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.domain.model.event.EventPayload;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.event.problems.attachment.MissingAttachment;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.exceptions.internal.SubmissionRequestException;
import dev.fitko.fitconnect.client.attachments.AttachmentPayloadHandler;
import java.util.List;
import java.util.UUID;

public class SubmissionAttachmentDownloader extends AttachmentDownloader<Submission> {

    private final ApplicationConfig config;

    public SubmissionAttachmentDownloader(
            final ApplicationConfig config,
            final FitConnectService fitConnectService,
            final AttachmentPayloadHandler attachmentPayloadHandler) {
        super(fitConnectService, attachmentPayloadHandler);
        this.config = config;
    }

    @Override
    protected String downloadAttachment(final Submission submission, final UUID attachmentId) {
        try {
            return fitConnectService.getSubmissionAttachment(submission.getSubmissionId(), attachmentId);
        } catch (final RestApiException e) {
            if (e.isNotFound()) {
                reject(submission, new MissingAttachment(attachmentId));
            }
            throw new SubmissionRequestException(e.getMessage(), e);
        }
    }

    @Override
    protected void reject(final Submission submission, final Problem problem) {
        if (config.isAutoRejectEnabled()) {
            LOGGER.info("Auto-rejecting submission due the following problem: {}", problem.getDetail());
            fitConnectService.rejectSubmission(EventPayload.forRejectEvent(submission, List.of(problem)));
        }
    }
}
