package dev.fitko.fitconnect.client.attachments.download;

import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.event.problems.attachment.MissingAttachment;
import dev.fitko.fitconnect.api.domain.model.reply.Reply;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectReplyException;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.client.attachments.AttachmentPayloadHandler;
import java.util.List;
import java.util.UUID;

public class ReplyAttachmentDownloader extends AttachmentDownloader<Reply> {

    private final ApplicationConfig config;

    public ReplyAttachmentDownloader(
            final ApplicationConfig config,
            final FitConnectService fitConnectService,
            final AttachmentPayloadHandler attachmentPayloadHandler) {
        super(fitConnectService, attachmentPayloadHandler);
        this.config = config;
    }

    @Override
    protected String downloadAttachment(final Reply reply, final UUID attachmentId) {
        try {
            return fitConnectService.getReplyAttachment(reply.getReplyId(), attachmentId);
        } catch (final RestApiException e) {
            if (e.isNotFound()) {
                reject(reply, new MissingAttachment(attachmentId));
            }
            throw new FitConnectReplyException(e.getMessage(), e);
        }
    }

    @Override
    protected void reject(final Reply reply, final Problem problem) {
        if (config.isAutoRejectEnabled()) {
            LOGGER.info("Auto-rejecting reply due the following problem: {}", problem.getDetail());
            fitConnectService.rejectReply(reply.getReplyId(), List.of(problem));
        }
    }
}
