package dev.fitko.fitconnect.api.services.schema;

import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import java.net.URI;
import java.util.Map;

/**
 * Service for loading XML schemas from various sources. This service is responsible for retrieving
 * XML schemas based on their URIs and providing them as input streams. The schemas are used for
 * validating XML documents in the FIT-Connect SDK.
 */
public interface XMLSchemaLoader {

    /**
     * Load XML schemas for a given URI. The URI can point to a local schema or a remote schema
     * accessible via HTTP/HTTPS. The method returns a map of schema identifiers to their
     * corresponding schema data as byte[].
     *
     * @param schemaUri the unique URN identifier of the XML schema
     * @return a map of schema identifiers to their corresponding schema data as byte[]
     * @throws RestApiException if the schema cannot be loaded or if a technical error occurs
     */
    Map<String, byte[]> loadSchemas(URI schemaUri) throws RestApiException;
}
