package dev.fitko.fitconnect.api.services.routing;

import dev.fitko.fitconnect.api.domain.model.route.Route;
import java.util.List;

/** Service to verify the validity of routing-related data. */
public interface RoutingVerificationService {

    /**
     * Verifies host url, self-service portal signature and DVDV signature of the provided {@link
     * Route}s. Invalid routes are filtered out and validation errors are logged.
     *
     * @param routes list of routes to be verified
     * @param requestedServiceIdentifier requested service identifier to be checked if the route
     *     supports it
     * @param requestedRegion requested service region to be checked if the routes supports it
     * @return filtered list of valid {@link Route}s, invalid routes are excluded and errors are
     *     logged
     */
    List<Route> validateRouteDestinations(
            List<Route> routes, String requestedServiceIdentifier, String requestedRegion);
}
