package dev.fitko.fitconnect.api.services.routing;

import dev.fitko.fitconnect.api.domain.model.route.Area;
import dev.fitko.fitconnect.api.domain.model.route.AreaResult;
import dev.fitko.fitconnect.api.domain.model.route.Route;
import dev.fitko.fitconnect.api.domain.model.route.RouteResult;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import java.util.List;

/** Routing API Service that retrieves data form FIT-Connect Routing API REST-Endpoints */
public interface RoutingService {

    /**
     * Finds an {@link AreaResult} based on a list of multiple filter criteria include a zip code or
     * e.g. city as in List.of("04229", "Leip*").
     *
     * @param searchExpressions list of string filters
     * @param offset offset to start from
     * @param limit max entries
     * @return list of {@link Area}
     * @throws RestApiException if a technical error occurred
     */
    AreaResult getAreas(List<String> searchExpressions, int offset, int limit) throws RestApiException;

    /**
     * Finds a {@link RouteResult} by a given service identifier and AT LEAST ONE OTHER search
     * criterion (ars | ags | areaId).
     *
     * @param leikaKey leikaKey
     * @param ars amtlicher regionalschlüssel
     * @param ags amtlicher gemeindeschlüssel
     * @param areaId areaId
     * @param offset offset to skip n elements
     * @param limit max entries per request
     * @return list of found {@link Route}s matching the search criteria
     * @throws RestApiException if a technical error occurred
     */
    RouteResult getRoutes(String leikaKey, String ars, String ags, String areaId, int offset, int limit)
            throws RestApiException;
}
