package dev.fitko.fitconnect.api.services.events;

import com.nimbusds.jwt.SignedJWT;
import dev.fitko.fitconnect.api.domain.model.event.EventLog;
import dev.fitko.fitconnect.api.domain.model.event.EventPayload;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.exceptions.internal.EventCreationException;

/**
 * A service that creates SET events that are added to a {@link Submission}s {@link EventLog}.
 *
 * @see CaseService
 * @see <a href="https://docs.fitko.de/fit-connect/docs/getting-started/event-log/events">Event
 *     Documentation</a>
 */
public interface SecurityEventService {

    /**
     * Create a new accept_submission event for a valid submission.
     *
     * @param eventPayload all necessary data for creating an event
     * @return SignedJWT with signed and SET encoded event
     * @throws EventCreationException if the signing key is invalid or the event could not be signed
     */
    SignedJWT createAcceptSubmissionEvent(EventPayload eventPayload);

    /**
     * Create a new reject_submission event for an invalid submission.
     *
     * @param eventPayload all necessary data for creating an event
     * @return SignedJWT with signed and SET encoded event
     * @throws EventCreationException if the signing key is invalid or the event could not be signed
     */
    SignedJWT createRejectSubmissionEvent(EventPayload eventPayload);
}
