package dev.fitko.fitconnect.api.services.events;

import com.nimbusds.jwt.SignedJWT;
import dev.fitko.fitconnect.api.domain.model.event.Event;
import dev.fitko.fitconnect.api.domain.model.event.EventLog;
import dev.fitko.fitconnect.api.domain.validation.ValidationContext;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import java.util.List;

/**
 * Verification service that validates the {@link Event}s of an {@link EventLog}.
 *
 * @see <a
 *     href="https://docs.fitko.de/fit-connect/docs/getting-started/event-log/set-validation/">SET-Validation</a>
 */
public interface EventLogVerificationService {

    /**
     * Validates all entries of an {@link EventLog} by verifying cryptographic standards, the
     * structure and validity of the SETs signatures.
     *
     * @param context {@link ValidationContext} configuration with all data needed to validate the
     *     event log
     * @param eventTokens list of set-events that should be validated
     * @return a {@link ValidationResult} with an optional error
     */
    List<ValidationResult> validateEventLogs(ValidationContext context, List<SignedJWT> eventTokens);
}
