package dev.fitko.fitconnect.api.services.auth;

import dev.fitko.fitconnect.api.domain.auth.OAuthToken;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.domain.model.submission.SubmitSubmission;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;

/**
 * A service that provides an interface to authenticate against the FIT-Connect API in order to send
 * a {@link SubmitSubmission} or to receive a {@link Submission}.
 *
 * @see <a href="https://docs.fitko.de/fit-connect/docs/getting-started/authentication">Fit-Connect
 *     documentation on authentication</a>
 */
public interface OAuthService {

    /**
     * Authenticates the sender/subscriber against the FIT-Connect API and retrieves an authentication
     * token in JSON-Web-Token (JWT) format. A re-authentication is automatically initiated if the
     * token should be expired.
     *
     * @return {@link OAuthToken} that holds the JWT as string
     * @throws RestApiException if an error occurred, including the original cause
     */
    OAuthToken getCurrentToken() throws RestApiException;
}
