package dev.fitko.fitconnect.api.exceptions.internal;

public class RestApiException extends RuntimeException {

    private int statusCode = 500;

    public RestApiException(final String errorMessage, final Throwable error) {
        super(errorMessage, error);
    }

    public RestApiException(final String errorMessage, final Throwable error, final int statusCode) {
        super(errorMessage, error);
        this.statusCode = statusCode;
    }

    public RestApiException(final String errorMessage) {
        super(errorMessage);
    }

    public RestApiException(final String errorMessage, int statusCode) {
        super(errorMessage);
        this.statusCode = statusCode;
    }

    public RestApiException fromRootCause(Throwable throwable) {
        return new RestApiException(throwable.getMessage(), throwable, this.statusCode);
    }

    public int getStatusCode() {
        return statusCode;
    }

    public boolean isNotFound() {
        return this.statusCode == 404;
    }

    public boolean isStatusCodeSuccessful() {
        return statusCode >= 200 && statusCode <= 226;
    }

    public boolean isClientError() {
        return statusCode >= 400 && statusCode < 500;
    }

    public boolean isServerError() {
        return statusCode >= 500;
    }
}
