package dev.fitko.fitconnect.api.exceptions;

import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import java.util.Optional;

public class ApiException extends RuntimeException {

    public ApiException(String errorMessage, Throwable throwable) {
        super(errorMessage, throwable);
    }

    public ApiException(String errorMessage) {
        super(errorMessage);
    }

    /**
     * Gets an API-Exception to be able to evaluate http status codes and errors.
     *
     * @return optional of the API Exception
     */
    public Optional<RestApiException> getApiException() {
        final Throwable cause = getCause();
        if (cause instanceof RestApiException) {
            final Throwable rootCause = getRootCause(cause);
            return Optional.of(((RestApiException) cause).fromRootCause(rootCause));
        }
        return Optional.empty();
    }

    /**
     * Gets the root cause of a {@link Throwable} by iterating through all causes.
     *
     * @param throwable the error that should be searched
     * @return the first cause in a chain of causes
     */
    Throwable getRootCause(Throwable throwable) {
        Throwable rootCause = throwable;
        while (rootCause.getCause() != null && rootCause.getCause() != rootCause) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }
}
