package dev.fitko.fitconnect.api.domain.zbp.state;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.UUID;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Builder
@Getter
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode
public class CreateState {

    @JsonProperty("applicationId")
    private UUID applicationId;

    @JsonProperty("status")
    private State state;

    @JsonProperty("publicServiceName")
    private PublicServiceName publicServiceName;

    @JsonProperty("statusDetails")
    private StatusDetails statusDetails;

    @JsonProperty("additionalInformation")
    private AdditionalInformation additionalInformation;

    @JsonProperty("reference")
    private String reference;

    @JsonProperty("senderName")
    private String senderName;

    @JsonProperty("createdDate")
    private Instant createdDate;
}
