package dev.fitko.fitconnect.api.domain.zbp.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.zbp.attachment.ZBPAttachmentMetadata;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class CreateMessage {

    @JsonProperty("mailboxUuid")
    private UUID mailboxUuid;

    @JsonProperty("applicationId")
    private UUID applicationId;

    @JsonProperty("stork_qaa_level")
    private AuthenticationLevel stork_qaa_level;

    @JsonProperty("sender")
    private String sender;

    @JsonProperty("title")
    private String title;

    @JsonProperty("content")
    private String content;

    @JsonProperty("service")
    private String service;

    @JsonProperty("retrievalConfirmationAddress")
    private String retrievalConfirmationAddress;

    @JsonProperty("replyAddress")
    private String replyAddress;

    @JsonProperty("reference")
    private String reference;

    @JsonProperty("senderUrl")
    private URI senderUrl;

    @Builder.Default
    @JsonProperty("attachments")
    private List<ZBPAttachmentMetadata> attachmentMetadata = new ArrayList<>();
}
