package dev.fitko.fitconnect.api.domain.zbp.message;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import lombok.Getter;

/** Representation of the STORK-QAA-Levels */
@Getter
public enum AuthenticationLevel {

    /** Basisregistrierung */
    ONE(1),

    /** Niedrig */
    TWO(2),

    /** Substantiell */
    THREE(3),

    /** Hoch */
    FOUR(4);

    @JsonValue
    private final int level;

    AuthenticationLevel(int level) {
        this.level = level;
    }

    public static AuthenticationLevel fromInt(int level) {
        return Arrays.stream(values())
                .filter(a -> a.getLevel() == level)
                .findFirst()
                .orElseThrow(() -> new IllegalArgumentException("AuthenticationLevel not available"));
    }
}
