package dev.fitko.fitconnect.api.domain.subscriber.steps;

import com.nimbusds.jose.jwk.JWK;
import java.net.URI;

public interface ReplyDataStep {

    /**
     * Set JSON data as string.
     *
     * @param data json as string
     * @param schemaUri specifies the schema that will be used to validate the data
     * @return next step to set additional properties
     */
    OptionalReplyPropertiesStep setJsonData(String data, URI schemaUri);

    /**
     * Set JSON data as byte[].
     *
     * @param data json data as bytes
     * @param schemaUri specifies the schema that will be used to validate the data
     * @return next step to set additional properties
     */
    OptionalReplyPropertiesStep setJsonData(byte[] data, URI schemaUri);

    /**
     * Set XML data as string.
     *
     * @param data xml data as string
     * @param schemaUri specifies the schema that will be used to validate the data
     * @return next step to set additional properties
     */
    OptionalReplyPropertiesStep setXmlData(String data, URI schemaUri);

    /**
     * Set XML data as byte[].
     *
     * @param data xml data as bytes
     * @param schemaUri specifies the schema that will be used to validate the data
     * @return next step to set additional properties
     */
    OptionalReplyPropertiesStep setXmlData(byte[] data, URI schemaUri);

    /**
     * Set the encryption key to encrypt the reply data, attachments, and metadata.
     *
     * @param replyEncryptionKey the JSON Web Key (JWK) to use for encrypting
     * @return next step to set data
     * @see com.nimbusds.jose.jwk.JWK
     */
    ReplyDataStep setReplyEncryptionKey(JWK replyEncryptionKey);
}
