package dev.fitko.fitconnect.api.domain.subscriber.steps;

import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.subscriber.SendableReply;
import java.util.List;

public interface OptionalReplyPropertiesStep {

    /**
     * Sends the submission with a list of attachments
     *
     * @param attachments that are sent with the submission
     * @return next step to set more additional attachments
     */
    OptionalReplyPropertiesStep addAttachments(List<Attachment> attachments);

    /**
     * Sends the submission with an attachments
     *
     * @param attachment that is sent with the submission
     * @return next step to set more additional attachments
     */
    OptionalReplyPropertiesStep addAttachment(Attachment attachment);

    /**
     * Constructs a new sendable reply from the data that is set.
     *
     * @return SendableSubmission
     */
    SendableReply build();
}
