package dev.fitko.fitconnect.api.domain.subscriber;

import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.model.event.Status;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
public class ReceivedSubmissionData {
    byte[] data;
    Metadata metadata;
    Submission submission;
    Status submissionStatus;

    @Builder.Default
    List<Attachment> attachments = new ArrayList<>();

    @Builder.Default
    Map<UUID, String> attachmentAuthTags = new HashMap<>();
}
