package dev.fitko.fitconnect.api.domain.sender.steps.unencrypted;

import dev.fitko.fitconnect.api.domain.model.submission.PublicService;

public interface ServiceTypeStep {

    /**
     * Set the {@link PublicService} for a submission. <br>
     * Service identifier example: urn:de:fim:leika:leistung:99400048079000
     *
     * @param serviceIdentifier unique identifier of the service
     * @param serviceName a name of the service
     * @return next step to add data
     * @see <a href="https://fimportal.de/">FIM-Portal Search</a>
     * @see <a href="https://opengovtech.de/leika/">Opengovtech Leika Search</a>
     */
    DataStep setServiceType(String serviceIdentifier, String serviceName);

    /**
     * Set the {@link PublicService} for a submission within a specific region. <br>
     * Service identifier example: urn:de:fim:leika:leistung:99400048079000
     *
     * @param serviceIdentifier unique identifier of the service
     * @param serviceName a name of the service
     * @param serviceRegion a name of the region as ARS key (^DE[0-9]{0,12}$)
     * @return next step to add data
     * @see <a href="https://fimportal.de/">FIM-Portal Search</a>
     * @see <a href="https://opengovtech.de/leika/">Opengovtech Leika Search</a>
     */
    DataStep setServiceTypeWithRegion(String serviceIdentifier, String serviceName, String serviceRegion);
}
