package dev.fitko.fitconnect.api.domain.sender.steps.unencrypted;

import dev.fitko.fitconnect.api.domain.zbp.AuthorKeyPair;
import dev.fitko.fitconnect.api.domain.zbp.message.CreateMessage;
import dev.fitko.fitconnect.api.domain.zbp.state.CreateState;
import java.net.URI;

public interface DataStep {

    /**
     * Set JSON data as string.
     *
     * @param data json string
     * @param schemaUri specifies the schema that will be used to validate the data
     * @return next step to set optional properties
     */
    OptionalPropertiesStep setJsonData(String data, URI schemaUri);

    /**
     * Set JSON data as byte[].
     *
     * @param data json data as byte[]
     * @param schemaUri specifies the schema that will be used to validate the data
     * @return next step to set optional properties
     */
    OptionalPropertiesStep setJsonData(byte[] data, URI schemaUri);

    /**
     * Set XML data as string.
     *
     * @param data xml string
     * @param schemaUri specifies the schema that will be used to validate the data
     * @return next step to set optional properties
     */
    OptionalPropertiesStep setXmlData(String data, URI schemaUri);

    /**
     * Set XML data as byte[].
     *
     * @param data xml data as byte[]
     * @param schemaUri specifies the schema that will be used to validate the data
     * @return next step to set optional properties
     */
    OptionalPropertiesStep setXmlData(byte[] data, URI schemaUri);

    /**
     * Set a new {@link CreateMessage} that should be sent on behalf of an author.
     *
     * @param message the ZBP {@link CreateMessage} to be sent
     * @param authorKeyPair pair of author client certificate and private key
     * @return next step to set optional properties
     */
    OptionalPropertiesStep setZBPMessage(CreateMessage message, AuthorKeyPair authorKeyPair);

    /**
     * Set a new {@link CreateState} that should be sent on behalf of an author.
     *
     * @param state the ZBP {@link CreateState} to be sent
     * @param authorKeyPair pair of author client certificate and private key
     * @return next step to set optional properties
     */
    OptionalPropertiesStep setZBPState(CreateState state, AuthorKeyPair authorKeyPair);
}
