package dev.fitko.fitconnect.api.domain.sender.steps.encrypted;

import dev.fitko.fitconnect.api.domain.model.submission.PublicService;

public interface EncryptedServiceTypeStep {

    /**
     * Set the {@link PublicService} for the submission.
     *
     * @param serviceIdentifier unique identifier of the service in the form
     *     <b>urn:de:fim:leika:leistung:</b>
     * @param serviceName a name of the service
     * @return next step to add encrypted metadata
     * @see <a href="https://fimportal.de/">Search For Service Types</a>
     */
    EncryptedMetadataStep setServiceType(String serviceIdentifier, String serviceName);

    /**
     * Set the {@link PublicService} for the submission within a specific region.
     *
     * @param serviceIdentifier unique identifier of the service in the form
     *     <b>urn:de:fim:leika:leistung:</b>
     * @param serviceName a name of the service
     * @param serviceRegion service region as ARS key (^DE[0-9]{0,12}$)
     * @return next step to add encrypted metadata
     * @see <a href="https://fimportal.de/">Search For Service Types</a>
     */
    EncryptedMetadataStep setServiceTypeWithRegion(String serviceIdentifier, String serviceName, String serviceRegion);
}
