package dev.fitko.fitconnect.api.domain.sender.steps.encrypted;

import dev.fitko.fitconnect.api.domain.model.callback.Callback;
import dev.fitko.fitconnect.api.domain.sender.SendableEncryptedSubmission;
import java.net.URI;
import java.util.Map;
import java.util.UUID;

public interface EncryptedOptionalPropertiesStep {

    /**
     * Add a list of encrypted attachments to the submissions attachments.
     *
     * @param attachments map of (key, value) = attachmentId, encryptedAttachmentContent
     * @return next step to set more optional properties
     */
    EncryptedOptionalPropertiesStep addEncryptedAttachments(Map<UUID, String> attachments);

    /**
     * Add a new encrypted attachment to the submissions attachments.
     *
     * @param attachmentId UUID of the attachment to add
     * @param content the encrypted attachment content
     * @return next step to set more optional properties
     */
    EncryptedOptionalPropertiesStep addEncryptedAttachment(UUID attachmentId, String content);

    /**
     * Set {@link Callback} to get asynchronously notified about submission and reply status updates
     * without polling.
     *
     * @param callbackUri URI that should be called to notify the sender
     * @param callbackSecret secret to verify the callback
     * @return next step to set more optional properties
     * @see <a
     *     href="https://docs.fitko.de/fit-connect/docs/details/callbacks#callback-url">FIT-Connect
     *     documentation on callbacks</a>
     */
    EncryptedOptionalPropertiesStep setCallback(URI callbackUri, String callbackSecret);

    /**
     * Add the new submission to an existing case.
     *
     * @param caseID unique identifier of the submissions caseID
     * @return next step to set more optional properties
     */
    EncryptedOptionalPropertiesStep setCase(UUID caseID);

    /**
     * Constructs a new sendable encrypted submission from the data that is set.
     *
     * @return SendableEncryptedSubmission
     */
    SendableEncryptedSubmission build();
}
