package dev.fitko.fitconnect.api.domain.model.submission;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import java.util.UUID;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SentSubmission {

    @JsonProperty("destinationId")
    private UUID destinationId;

    @JsonProperty("submissionId")
    private UUID submissionId;

    @JsonProperty("caseId")
    private UUID caseId;

    @JsonProperty("authenticationTags")
    private AuthenticationTags authenticationTags;

    public SentSubmission(final UUID destinationId, final UUID caseId, final UUID submissionId) {
        this.destinationId = destinationId;
        this.caseId = caseId;
        this.submissionId = submissionId;
        authenticationTags = null;
    }
}
