package dev.fitko.fitconnect.api.domain.model.submission;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.callback.Callback;
import java.util.List;
import java.util.UUID;
import lombok.Builder;
import lombok.Data;

@Data
@Builder
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AnnounceSubmission {

    @JsonProperty("destinationId")
    private UUID destinationId;

    @JsonProperty("caseId")
    private UUID caseId;

    @JsonProperty("announcedAttachments")
    private List<UUID> announcedAttachments;

    @JsonProperty("publicService")
    private PublicService publicService;

    @JsonProperty("region")
    private String region;

    @JsonProperty("callback")
    private Callback callback;
}
