package dev.fitko.fitconnect.api.domain.model.route;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RouteProcessingDuration {

    @JsonProperty("minDuration")
    private Integer minDuration;

    @JsonProperty("maxDuration")
    private Integer maxDuration;

    @JsonProperty("unit")
    private UnitEnum unit;

    public enum UnitEnum {
        YEAR("year"),

        MONTH("month"),

        WEEK("week"),

        DAY("day"),

        WORKDAY("workday"),

        HOUR("hour"),

        MINUTE("minute"),

        SECOND("second");
        private String value;

        UnitEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static UnitEnum fromValue(String value) {
            for (UnitEnum b : values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}
