package dev.fitko.fitconnect.api.domain.model.route;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.destination.Status;
import dev.fitko.fitconnect.api.domain.model.jwk.ApiJwkSet;
import dev.fitko.fitconnect.api.domain.model.metadata.data.SubmissionSchema;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.ReplyChannel;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RouteDestination {

    @JsonProperty("encryptionKid")
    private String encryptionKid = null;

    @JsonProperty("metadataVersions")
    private List<String> metadataVersions = new ArrayList<>();

    @JsonProperty("publicKeys")
    private ApiJwkSet publicKeys = null;

    @JsonProperty("replyChannels")
    private ReplyChannel replyChannels = null;

    @JsonProperty("status")
    private Status status = null;

    @JsonProperty("submissionSchemas")
    private List<SubmissionSchema> submissionSchemas = new ArrayList<>();

    @JsonProperty("submissionUrl")
    private String submissionUrl = null;
}
