package dev.fitko.fitconnect.api.domain.model.route;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Data;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Route {

    @JsonProperty("destinationId")
    private UUID destinationId;

    @JsonProperty("destinationSignature")
    private String destinationSignature;

    @JsonProperty("destinationName")
    private String destinationName;

    @JsonProperty("destinationShortName")
    private String destinationShortName;

    @JsonProperty("destinationLogo")
    private URI destinationLogo;

    @JsonProperty("contactPersons")
    private List<ContactPerson> contactPersons = new ArrayList<>();

    @JsonProperty("address")
    private Address address;

    @JsonProperty("postalAddress")
    private PostalAddress postalAddress;

    @JsonProperty("postOfficeBox")
    private PostOfficeBox postOfficeBox;

    @JsonProperty("privacyPolicyUrl")
    private URI privacyPolicyUrl;

    @JsonProperty("imprintUrl")
    private URI imprintUrl;

    @JsonProperty("accessibilityUrl")
    private URI accessibilityUrl;

    @JsonProperty("contactFormUrl")
    private URI contactFormUrl;

    @JsonProperty("furtherInformation")
    private RouteFurtherInformation furtherInformation;

    @JsonProperty("requiredDocuments")
    private RouteRequiredDocuments requiredDocuments;

    @JsonProperty("legalBasis")
    private RouteLegalBasis legalBasis;

    @JsonProperty("deadline")
    private RouteDeadline deadline;

    @JsonProperty("processingDuration")
    private RouteProcessingDuration processingDuration;

    @JsonProperty("customParameters")
    private Object customParameters;

    @JsonProperty("origin")
    private String origin;
}
