package dev.fitko.fitconnect.api.domain.model.reply.replychannel;

import static com.fasterxml.jackson.databind.DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.JWK;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class EncryptionPublicKey {

    private static final ObjectMapper MAPPER = new ObjectMapper().configure(FAIL_ON_UNKNOWN_PROPERTIES, false);

    @JsonProperty("kty")
    private String kty;

    @JsonProperty("key_ops")
    private List<String> keyOps = new ArrayList<>();

    @JsonProperty("alg")
    private String alg;

    @JsonProperty("kid")
    private String kid;

    @JsonProperty("n")
    private String n;

    @JsonProperty("e")
    private String e;

    public static EncryptionPublicKey fromJwk(final JWK jwk) {
        final Map<String, Object> jsonObject = jwk.toJSONObject();
        try {
            return MAPPER.readValue(MAPPER.writeValueAsString(jsonObject), EncryptionPublicKey.class);
        } catch (final JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public JWK toJwk() {
        try {
            return JWK.parse(MAPPER.writeValueAsString(this));
        } catch (final JsonProcessingException | ParseException ex) {
            throw new RuntimeException(ex);
        }
    }
}
