package dev.fitko.fitconnect.api.domain.model.metadata.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class DataSet {

    @JsonProperty("dataSetId")
    private UUID dataSetId;

    @JsonProperty("schema")
    private DataSetSchema schema;

    @JsonProperty("hash")
    private DataSetHash hash;

    @JsonProperty("description")
    private String description;

    @JsonProperty("content")
    private String content;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class DataSetSchema {

        @JsonProperty("schemaUri")
        private String schemaUri;

        @JsonProperty("mimeType")
        private String mimeType;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class DataSetHash {

        @JsonProperty("type")
        private String type;

        @JsonProperty("content")
        private String content;
    }
}
