package dev.fitko.fitconnect.api.domain.model.metadata.payment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PaymentInformation {

    @JsonProperty("transactionUrl")
    private URI transactionUrl;

    @JsonProperty("transactionId")
    private String transactionId;

    @JsonProperty("transactionReference")
    private String transactionReference;

    @JsonProperty("transactionTimestamp")
    private String transactionTimestamp;

    @JsonProperty("paymentMethod")
    private PaymentMethod paymentMethod;

    @JsonProperty("paymentMethodDetail")
    private String paymentMethodDetail;

    @JsonProperty("status")
    private PaymentStatus status;

    @JsonProperty("grossAmount")
    private double grossAmount;
}
