package dev.fitko.fitconnect.api.domain.model.metadata.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MimeType {
    APPLICATION_JSON("application/json"),
    APPLICATION_XML("application/xml"),
    PLAIN_TEXT("text/plain"),
    APPLICATION_OCTET_STREAM("application/octet-stream"),
    APPLICATION_PDF("application/pdf");

    private static final Map<String, MimeType> CONSTANTS = new HashMap<>();

    static {
        for (final MimeType c : values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private final String value;

    MimeType(final String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static MimeType fromValue(final String value) {
        final MimeType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }

    /**
     * Get the file extension of the mime-type.
     *
     * @return string of the extension.
     */
    public String getExtension() {
        return value.split("/")[1];
    }
}
