package dev.fitko.fitconnect.api.domain.model.metadata.attachment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Purpose {
    FORM("form"),
    ATTACHMENT("attachment"),
    REPORT("report"),

    DATA("data");

    private final String value;

    private static final Map<String, Purpose> CONSTANTS = new HashMap<>();

    static {
        for (final Purpose p : values()) {
            CONSTANTS.put(p.value, p);
        }
    }

    Purpose(final String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    @JsonValue
    public String value() {
        return value;
    }

    @JsonCreator
    public static Purpose fromValue(final String value) {
        final Purpose constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }
}
