package dev.fitko.fitconnect.api.domain.model.metadata.attachment;

import dev.fitko.fitconnect.api.domain.model.attachment.Fragment;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public final class AttachmentForValidation {

    private UUID attachmentId;
    private String hash;
    private byte[] decryptedData;
    private String authTag;
    private ApiAttachment attachmentMetadata;
    private List<Fragment> fragments;
    private File dataFile;

    private AttachmentForValidation(
            final ApiAttachment attachmentMetadata,
            final byte[] decryptedData,
            final String authTag,
            final List<Fragment> fragments,
            final File dataFile) {
        this.attachmentMetadata = attachmentMetadata;
        this.decryptedData = decryptedData;
        this.authTag = authTag;
        this.dataFile = dataFile;
        this.fragments = fragments;
        attachmentId = attachmentMetadata.getAttachmentId();
        hash = attachmentMetadata.getHash().getContent();
    }

    public static AttachmentForValidation forFragmentedAttachment(
            final ApiAttachment attachmentMetadata, final List<Fragment> fragments, final File mergedFile) {
        return new AttachmentForValidation(attachmentMetadata, null, null, fragments, mergedFile);
    }

    public static AttachmentForValidation forAttachmentWithoutFragments(
            final ApiAttachment attachmentMetadata, final byte[] decryptedData, final String authTag) {
        return new AttachmentForValidation(attachmentMetadata, decryptedData, authTag, Collections.emptyList(), null);
    }

    public boolean hasFragmentedPayload() {
        return !fragments.isEmpty();
    }

    public boolean isDataAttachment() {
        return attachmentMetadata.getPurpose().equals(Purpose.DATA);
    }
}
