package dev.fitko.fitconnect.api.domain.model.metadata.attachment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.metadata.Hash;
import dev.fitko.fitconnect.api.domain.model.metadata.Signature;
import java.util.List;
import java.util.UUID;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ApiAttachment {

    @JsonProperty("hash")
    private Hash hash;

    @JsonProperty("signature")
    private Signature signature;

    @JsonProperty("purpose")
    private Purpose purpose;

    @JsonProperty("filename")
    private String filename;

    @JsonProperty("description")
    private String description;

    @JsonProperty("mimeType")
    private String mimeType;

    @JsonProperty("attachmentId")
    private UUID attachmentId;

    @JsonProperty("fragments")
    private List<UUID> fragments;

    @JsonIgnore
    public boolean hasFragments() {
        return fragments != null && !fragments.isEmpty();
    }
}
