package dev.fitko.fitconnect.api.domain.model.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SignatureType {
    SHA_512("sha512");

    private static final Map<String, SignatureType> CONSTANTS = new HashMap<>();

    static {
        for (final SignatureType c : values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private final String value;

    SignatureType(final String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SignatureType fromValue(final String value) {
        final SignatureType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }
}
