package dev.fitko.fitconnect.api.domain.model.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SignatureFormat {
    CMS("cms"),
    XML("xml"),
    PDF("pdf"),
    ASIC("asic"),
    JSON("json");

    private static final Map<String, SignatureFormat> CONSTANTS = new HashMap<>();

    static {
        for (final SignatureFormat c : values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private final String value;

    SignatureFormat(final String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SignatureFormat fromValue(final String value) {
        final SignatureFormat constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }
}
