package dev.fitko.fitconnect.api.domain.model.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.metadata.payment.PaymentInformation;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.ReplyChannel;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Setter
@EqualsAndHashCode
@AllArgsConstructor
@NoArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class Metadata {

    @Getter
    @JsonProperty("$schema")
    private String schema;

    @Getter
    @JsonProperty("contentStructure")
    private ContentStructure contentStructure = new ContentStructure();

    @Getter
    @JsonProperty("paymentInformation")
    private PaymentInformation paymentInformation;

    @Getter
    @JsonProperty("replyChannel")
    private ReplyChannel replyChannel;

    @Getter
    @JsonProperty("additionalReferenceInfo")
    private AdditionalReferenceInfo additionalReferenceInfo;
}
