package dev.fitko.fitconnect.api.domain.model.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AuthenticationInformation {

    @JsonProperty("type")
    private String type;

    @JsonProperty("version")
    private String version;

    @JsonProperty("content")
    private String content;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private String version;
        private String content;

        public Builder withType(final String type) {
            this.type = type;
            return this;
        }

        public Builder withVersion(final String version) {
            this.version = version;
            return this;
        }

        public Builder withContent(final String content) {
            this.content = content;
            return this;
        }

        public AuthenticationInformation build() {
            return new AuthenticationInformation(type, version, content);
        }
    }
}
