package dev.fitko.fitconnect.api.domain.model.jwk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum KeyOpsEnum {
    VERIFY("verify"),

    WRAPKEY("wrapKey");

    private static final Map<String, KeyOpsEnum> CONSTANTS = new HashMap<>();

    static {
        for (final KeyOpsEnum c : values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private final String value;

    KeyOpsEnum(final String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static KeyOpsEnum fromValue(final String value) {
        final KeyOpsEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }
}
