package dev.fitko.fitconnect.api.domain.model.jwk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum EEnum {
    AQAB("AQAB");

    private static final Map<String, EEnum> CONSTANTS = new HashMap<>();

    static {
        for (final EEnum c : values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private final String value;

    EEnum(final String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static EEnum fromValue(final String value) {
        final EEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }
}
