package dev.fitko.fitconnect.api.domain.model.jwk;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class ApiJwk {

    @JsonProperty("kty")
    private KtyEnum kty;

    @JsonProperty("key_ops")
    private List<KeyOpsEnum> keyOps = new ArrayList<>();

    @JsonProperty("alg")
    private AlgEnum alg;

    @JsonProperty("x5c")
    private List<String> x5c = new ArrayList<>();

    @JsonProperty("kid")
    private String kid;

    @JsonProperty("n")
    private String n;

    @JsonProperty("e")
    private EEnum e;
}
