package dev.fitko.fitconnect.api.domain.model.jwk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum AlgEnum {
    PS512("PS512"),

    RSA_OAEP_256("RSA-OAEP-256");

    private static final Map<String, AlgEnum> CONSTANTS = new HashMap<>();

    static {
        for (final AlgEnum c : values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private final String value;

    AlgEnum(final String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static AlgEnum fromValue(final String value) {
        final AlgEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }
}
