package dev.fitko.fitconnect.api.domain.model.event.problems.metadata;

import static java.lang.String.format;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;

public final class UnsupportedMetadataSchema extends Problem {

    private static final String TYPE = SCHEMA_URL + "unsupported-schema";
    private static final String TITLE = "Metadata schema not supported";
    private static final String DETAIL =
            "The specified metadata schema URI ('%s') is not referring to a supported metadata schema.";
    private static final String INSTANCE = "metadata";

    public UnsupportedMetadataSchema(final String metadataSchemaUri) {
        super(TYPE, TITLE, format(DETAIL, metadataSchemaUri), INSTANCE);
    }
}
