package dev.fitko.fitconnect.api.domain.model.event.problems.metadata;

import static java.lang.String.format;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;

public final class MetadataEncryptionKeyIssue extends Problem {

    private static final String TYPE = SCHEMA_URL + "encryption-issue";
    private static final String TITLE = "Encryption failure";
    private static final String DETAIL = "The key %s is not the key intended for this purpose.";
    private static final String INSTANCE = "metadata";

    public MetadataEncryptionKeyIssue(final String keyId) {
        super(TYPE, TITLE, format(DETAIL, keyId), INSTANCE);
    }
}
