package dev.fitko.fitconnect.api.domain.model.event.problems.attachment;

import static java.lang.String.format;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import java.util.UUID;

public final class MissingAttachment extends Problem {
    private static final String TYPE = SCHEMA_URL + "missing-attachment";
    private static final String TITLE = "List of attachments is invalid";
    private static final String DETAIL = "Unable to load attachment %s.";
    private static final String INSTANCE = "attachment:%s";

    public MissingAttachment(final UUID attachmentId) {
        super(TYPE, TITLE, format(DETAIL, attachmentId), format(INSTANCE, attachmentId));
    }
}
