package dev.fitko.fitconnect.api.domain.model.event.problems.attachment;

import static java.lang.String.format;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import java.util.UUID;

public final class InvalidAttachmentContent extends Problem {

    private static final String TYPE = SCHEMA_URL + "invalid-content";
    private static final String TITLE = "Invalid content";
    private static final String DETAIL = "The content of the attachment %s is not allowed.";
    private static final String INSTANCE = "attachment:%s";

    public InvalidAttachmentContent(final UUID attachmentId) {
        super(TYPE, TITLE, format(DETAIL, attachmentId), format(INSTANCE, attachmentId));
    }
}
