package dev.fitko.fitconnect.api.domain.model.event.problems.attachment;

import static java.lang.String.format;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import java.util.UUID;

public final class IncorrectAttachmentAuthenticationTag extends Problem {

    private static final String TYPE = SCHEMA_URL + "incorrect-authentication-tag";
    private static final String TITLE = "Authentication tag is invalid";
    private static final String DETAIL = "The authentication tag for the attachment %s is invalid.";
    private static final String INSTANCE = "attachment:%s";

    public IncorrectAttachmentAuthenticationTag(final UUID attachmentId) {
        super(TYPE, TITLE, format(DETAIL, attachmentId), format(INSTANCE, attachmentId));
    }
}
