package dev.fitko.fitconnect.api.domain.model.event.problems.attachment;

import static java.lang.String.format;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import java.util.UUID;

public final class AttachmentHashMismatch extends Problem {

    private static final String TYPE = SCHEMA_URL + "hash-mismatch";
    private static final String TITLE = "Checksum does not match";
    private static final String DETAIL = "Attachment %s hash value is wrong.";
    private static final String INSTANCE = "attachment:%s";

    public AttachmentHashMismatch(final UUID attachmentId) {
        super(TYPE, TITLE, format(DETAIL, attachmentId), format(INSTANCE, attachmentId));
    }
}
