package dev.fitko.fitconnect.api.domain.model.event.problems.attachment;

import static java.lang.String.format;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;

public final class AttachmentEncryptionKeyIssue extends Problem {

    private static final String TYPE = SCHEMA_URL + "encryption-issue";
    private static final String TITLE = "Decryption failure";
    private static final String DETAIL = "The key %s is not the key intended for this purpose.";
    private static final String INSTANCE = "attachment:%s";

    public AttachmentEncryptionKeyIssue(final String keyId) {
        super(TYPE, TITLE, format(DETAIL, keyId), format(INSTANCE, keyId));
    }

    public static Problem getWithAttachmentId(final String keyId) {
        return new AttachmentEncryptionKeyIssue(keyId);
    }
}
