package dev.fitko.fitconnect.api.domain.model.event.problems.attachment;

import static java.lang.String.format;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import java.util.UUID;

public final class AttachmentEncryptionIssue extends Problem {

    private static final String TYPE = SCHEMA_URL + "encryption-issue";
    private static final String TITLE = "Decryption failure";
    private static final String DETAIL = "Decrypting attachment %s failed.";
    private static final String INSTANCE = "attachment:%s";

    public AttachmentEncryptionIssue(final UUID attachmentId) {
        super(TYPE, TITLE, format(DETAIL, attachmentId), format(INSTANCE, attachmentId));
    }
}
