package dev.fitko.fitconnect.api.domain.model.event.problems;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Superclass for all FIT-Connect problems.
 *
 * @see <a href="https://docs.fitko.de/fit-connect/docs/sending/accept-reject#aufbau">FIT-Connect
 *     Problems</a>
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Problem {

    @JsonIgnore
    public static final String SCHEMA_URL = "https://schema.fitko.de/fit-connect/events/problems/";

    @JsonProperty("type")
    private String type;

    @JsonProperty("title")
    private String title;

    @JsonProperty("detail")
    private String detail;

    @JsonProperty("instance")
    private String instance;
}
